local bpm = 190.00 * GAMESTATE:GetSongOptionsObject("ModsLevel_Current"):MusicRate()
local beat = 60/bpm

local keycount = 4
local timings = {
	{type = 1, row = {6816, 13056}, beats = 1, lanes = {1, 1, 1, 1}},
	{type = 1, row = {20640, 26880}, beats = 1, lanes = {1, 1, 1, 1}}
	
	--{type = 6, row = {0, 19776}, beats = 0.25, lanes = {1, 1, 1, 0}}
}

local t1start = true
local t2start = true

local applyModToLane = function(p1, timing, lane)
	local type = timing.type
	local beats = timing.beats
	
	local columns = p1:GetChild("NoteField"):get_column_actors()

	local a = columns[lane]
	
	if type == 1 then
	
		if timing.row[1] == 6816 and t1start then
			beats = beats * 4
			t1start = false
		end
		if timing.row[1] == 20640 and t2start and not t1start then
			beats = beats * 4
			t2start = false
		end
		
		a:finishtweening()
		a:decelerate(beats/2 * beat)
		a:addrotationz(lane < 3 and 180 or -180)
		a:y(SCREEN_HEIGHT-p1:GetY()*1.6)
		a:addx(lane < 3 and -SCREEN_WIDTH*0.025 or SCREEN_WIDTH*0.025)
		
		a:decelerate(beats/2 * beat)
		a:addrotationz(lane < 3 and -180 or 180)
		a:y(1)
		a:addx(lane < 3 and SCREEN_WIDTH*0.025 or -SCREEN_WIDTH*0.025)
		
	end
end
local applyMod = function(p1, timing, lane)
	if lane then
		if timing.lanes[lane] == 1 then
			applyModToLane(p1, timing, lane)
		end
	else
		for lane,active in ipairs(timing.lanes) do
			if active == 1 then
				applyModToLane(p1, timing, lane)
			end
		end
	end
end

local t = Def.ActorFrame{}

t.JudgmentMessageCommand = function(self, param)
	local p1 = SCREENMAN:GetTopScreen():GetChild("PlayerP1")
	local row = param.NoteRow
	
	if row then
		for i,timing in pairs(timings) do
			if type(timing.row) == "table" then
				if row >= timing.row[1] and row <= timing.row[2] then
					applyMod(p1, timing, param.FirstTrack+1)
					
				elseif row > timing.row[2] then
					timings[i] = nil
				end
			else
				if row == timing.row then
					applyMod(p1, timing)
					
					timings[i] = nil
				end
			end
		end
	end
end

return t